/*=============================================================================}
{ This demo shows how to use Tags of items.                                    }
{ Each item has associated integer value - Tag. Tags are used to store         }
{ additional information, which RichView does not display and does not use.    }
{------------------------------------------------------------------------------}
{ All Add*** methods (except from obsolete ones) has Add***Tag version.        }
{ Add***(...) == Add***Tag(...,0) (Tags=0 by default)                          }
{ For example, look AddNLTag and AddHotpotExTag in this demo.                  }
{ Tag of item can be obtained with GetItemTag method (or Get***Info methods)   }
{ and modified with SetItemTag (or Set***Info methods).                        }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichView1->AddNL("Some text styles can be chosen as hypertext styles. ",0,0);
  RichView1->AddNLTag("Like this one.",4,-1, 100);
  RichView1->AddNL(" You can have as many hypertext styles as you want.  ",0,-1);
  RichView1->AddNLTag("Here is one more.",5,-1,  200);
  RichView1->AddNL("Images from Image Lists also can be hypertext: ",0,0);
  RichView1->AddHotspotExTag("Pen Image", 0,1, ImageList1, -1, 300);
  RichView1->AddNL(" Such images are called 'hotspots'.",0,-1);
  TIcon* ico = new TIcon;
  ico->Assign(Image1->Picture->Graphic);
  RichView1->AddHotPictureTag("Bobo", ico, -1, rvvaBaseline, 400);
  RichView1->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1Jump(TObject *Sender, int id)
{
  int ItemNo = RichView1->GetJumpPointItemNo(id);
  int Tag    = RichView1->GetItemTag(ItemNo);
  Panel1->Caption = AnsiString("Clicked: Item with Tag=")+IntToStr(Tag);
}
//---------------------------------------------------------------------------
